<?php

/**
 * Description of Script
 *
 * @author jorge
 */


class Script {

    const REDIRECT_SELF         = 'self';
    const DEFAULT_REDIRECT_SELF = TRUE;

    /**
     * Realiza una redirección (header:redirection).
     * @param string $url Dirección URL de la página destino o ruta completa (ver $absolute).
     * @param array $options Opciones de salto:
     *         boolean 'absolute' Añade el dominio y la carpeta en donde está la página llamadora. Por defecto FALSE. self::REDIRECT_ABSOLUTE.
     *         boolean 'self' Salta a la misma pestaña. Por defecto FALSE. self::REDIRECT_SELF.
     */
    public static function redirect(string $url, array $options = []) {

        if (isset($options[self::REDIRECT_SELF])) {
            if (!\is_bool($options[self::REDIRECT_SELF])) {
                $options[self::REDIRECT_SELF] = self::DEFAULT_REDIRECT_SELF;
            }
        } else {
            $options[self::REDIRECT_SELF] = self::DEFAULT_REDIRECT_SELF;
        }

        $self = $options[self::REDIRECT_SELF];
        $uri  = $url;

        \ob_start();
        if (!self::outputSend()) {
            \header("location:{$uri}");
            \ob_end_flush();
            exit(0);
        }

        $output = "<script type='text/javascript'>";
        if ($self) {
            $output .= "window.open('{$uri}', '_self');";
        } else {
            $output .= "window.location.href='{$uri}';";
        }
        $output .= "</script>"
                . "<noscript>"
                . "<meta http-equiv='refresh' content='0,url={$uri}' />"
                . "</noscript>";
        echo $output;

        \ob_end_flush();
    }

    /**
     * Retorna la URI actual
     * @return string
     */
    public static function getCurrentUri(): bool {
        $self = $_SERVER['PHP_SELF'];
        return (isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . \mb_substr($self, 0, \mb_strrpos($self, '/')) . '/';
    }

    public static function outputSend(): bool {
        if (!\headers_sent() && \error_get_last() == NULL)
            return false;

        return true;
    }

    /**
     * Retorna la IP actual del cliente
     * @return string
     */
    public static function getClientIp() {
        $ip = self::getClientIpServer();
        if (\mb_strlen($ip) < 7) {
            $ip = self::getClientIpEnv();
        }
        return $ip;
    }

    /**
     * Retorna la IP actual del cliente usando
     * las variables de ambiente de php
     * @return string
     */
    public static function getClientIpEnv() {
        $ipAddress = '';
        if (\getenv('HTTP_CLIENT_IP')) {
            $ipAddress = \getenv('HTTP_CLIENT_IP');
        } else if (\getenv('HTTP_X_FORWARDED_FOR')) {
            $ipAddress = \getenv('HTTP_X_FORWARDED_FOR');
        } else if (\getenv('HTTP_X_FORWARDED')) {
            $ipAddress = \getenv('HTTP_X_FORWARDED');
        } else if (\getenv('HTTP_FORWARDED_FOR')) {
            $ipAddress = \getenv('HTTP_FORWARDED_FOR');
        } else if (\getenv('HTTP_FORWARDED')) {
            $ipAddress = \getenv('HTTP_FORWARDED');
        } else if (\getenv('REMOTE_ADDR')) {
            $ipAddress = \getenv('REMOTE_ADDR');
        }

        return $ipAddress;
    }

    /**
     * Retorna la IP actual del cliente usando
     * el array server
     * @return string
     */
    public static function getClientIpServer() {
        $ipAddress = '';
        if (\filter_input(INPUT_SERVER, 'HTTP_CLIENT_IP')) {
            $ipAddress = \filter_input(INPUT_SERVER, 'HTTP_CLIENT_IP');
        } else if (\filter_input(INPUT_SERVER, 'HTTP_X_FORWARDED_FOR')) {
            $ipAddress = \filter_input(INPUT_SERVER, 'HTTP_X_FORWARDED_FOR');
        } else if (\filter_input(INPUT_SERVER, 'HTTP_X_FORWARDED')) {
            $ipAddress = \filter_input(INPUT_SERVER, 'HTTP_X_FORWARDED');
        } else if (\filter_input(INPUT_SERVER, 'HTTP_FORWARDED_FOR')) {
            $ipAddress = \filter_input(INPUT_SERVER, 'HTTP_FORWARDED_FOR');
        } else if (\filter_input(INPUT_SERVER, 'HTTP_FORWARDED')) {
            $ipAddress = \filter_input(INPUT_SERVER, 'HTTP_FORWARDED');
        } else if (\filter_input(INPUT_SERVER, 'REMOTE_ADDR')) {
            $ipAddress = \filter_input(INPUT_SERVER, 'REMOTE_ADDR');
        }
        return $ipAddress;
    }

    /**
     * Ejecuta un comando en background
     * @param string $cmd
     */
    public static function execInBackground($cmd) {
        if (\substr(\php_uname(), 0, 7) == "Windows") {
            \pclose(\popen("start /B " . $cmd, "r"));
        } else {
            \exec($cmd . " > /dev/null &");
        }
    }

}
