<?php

$json = \file_get_contents('php://input');

$data = \json_decode($json, true);

$configDb = require_once('./config/db_config.php');

$db = new PDO("mysql:host={$configDb['host']};dbname={$configDb['db_name']}", $configDb['user'], $configDb['pass']);

$stmt = $db->prepare('INSERT INTO notificaciones set user_id=?, application_id=?, topic=?,resource=?, mensaje=?, fh_registro=?;');

$stmtResult = $stmt->execute([
    $data['user_id'],
    $data['application_id'],
    $data['topic'],
    $data['resource'],
    $json,
    \date('Y-m-d H:i:s'),
        ]);

if (!$stmtResult) {
    $error = \json_encode([
        'db'     => $db->errorInfo(),
        'record' => $stmt->errorInfo()
    ]);
    $filename = '_error_'.\date('Ymd_His_U').'.json';
    \file_put_contents($filename, $error);

}
else{

    \http_response_code(200);
    $usuario = $data['user_id'];
    
    //Obtengo URL
    $stmt = $db->prepare("SELECT URL_CheckML FROM config_usu WHERE id_usuario=?");
    $stmt->execute([$usuario]); 
    $user = $stmt->fetch();
    $URL_CheckML = $user['URL_CheckML'];
    if(is_null($URL_CheckML)){

        //Si no exite, creo el registro
        echo "URL_CheckML no encontrado<br />\n";
     
    }else{
        $url = $URL_CheckML."?user_id={$usuario}";  //$url="https://melipruebas.infotech.com.ar/CheckML/CheckML.php?user_id={$usuario}";
        $respuesta = \file_get_contents($url);    //Llama al proceso 
        //if($usuario=='181701767'){
        //    \file_put_contents('_'.\date('YmdHis_U') . '_CheckML_respuesta.txt', $url.' '.$respuesta);  //guarda un log
        //}
    }

    exit(0);
}

